/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.soundscool.network.packet.client;

import com.dynious.soundscool.SoundsCool;
import com.dynious.soundscool.network.packet.IPacket;
import com.dynious.soundscool.network.packet.server.ServerPlaySoundPacket;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.buffer.ByteBuf;
import net.minecraft.world.World;

public class ClientPlaySoundPacket
implements IPacket {
    String soundName;
    int dimensionId;
    int x;
    int y;
    int z;

    public ClientPlaySoundPacket() {
    }

    public ClientPlaySoundPacket(String soundName, World world, int x, int y, int z) {
        this.soundName = soundName;
        this.dimensionId = world.field_73011_w.field_76574_g;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void readBytes(ByteBuf bytes) {
        int soundLength = bytes.readInt();
        char[] fileCars = new char[soundLength];
        for (int i = 0; i < soundLength; ++i) {
            fileCars[i] = bytes.readChar();
        }
        this.soundName = String.valueOf(fileCars);
        this.dimensionId = bytes.readInt();
        this.x = bytes.readInt();
        this.y = bytes.readInt();
        this.z = bytes.readInt();
        SoundsCool.proxy.getChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        SoundsCool.proxy.getChannel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(this.dimensionId, (double)this.x, (double)this.y, (double)this.z, 64.0));
        SoundsCool.proxy.getChannel().writeOutbound(new Object[]{new ServerPlaySoundPacket(this.soundName, "", this.x, this.y, this.z)});
    }

    @Override
    public void writeBytes(ByteBuf bytes) {
        bytes.writeInt(this.soundName.length());
        for (char c : this.soundName.toCharArray()) {
            bytes.writeChar((int)c);
        }
        bytes.writeInt(this.dimensionId);
        bytes.writeInt(this.x);
        bytes.writeInt(this.y);
        bytes.writeInt(this.z);
    }
}

